/*____________________________________________________________________________
	Copyright (C) 2000 Networks Associates Technology, Inc.
	All rights reserved.

	$Id: pgpFIPS.c,v 1.5 2001/01/25 22:11:53 jeffc Exp $
____________________________________________________________________________*/
#include "pgpDSAKey.h"
#include "pgpErrors.h"
#include "pgpFIPSPriv.h"
#include "pgpSDKPriv.h"
#include "pgpSymmetricCipherPriv.h"
#include "pgpUtilities.h"
#include "pgpDebug.h"

static PGPError		sSDKError	 			= kPGPError_NoErr;
static PGPBoolean	sHaveRunAllSelfTests 	= FALSE;
static PGPBoolean	sFIPSModeEnabled 		= FALSE;

	PGPError
PGPGetSDKErrorState(void)
{
	return( sSDKError );
}

	PGPError
PGPResetSDKErrorState(void)
{
	if( pgpFIPSModeEnabled() )
	{
		PGPBoolean	runTests = IsPGPError( sSDKError );

		sSDKError = kPGPError_NoErr;
		
		if( runTests && pgpFIPSModeEnabled() )
		{
			PGPRunAllSDKSelfTests();
		}
	}
	
	return( sSDKError );
}

	void
pgpSetSDKErrorState(PGPError err)
{
	if( pgpFIPSModeEnabled() )
	{
		if( IsntPGPError( sSDKError ) )
			sSDKError = err;
	}
}

	PGPBoolean
pgpHaveRunAllSelfTests(void)
{
	return sHaveRunAllSelfTests;
}

	PGPError
PGPRunSDKSelfTest(PGPsdkSelfTest whichTest)
{
	PGPError	err = kPGPError_NoErr;
	
	if( ! pgpFIPSModeEnabled() )
	{
		pgpDebugMsg( "PGPRunSDKSelfTest: Cannot run self test "
						"without FIPS mode enabled" );
		return kPGPError_BadParams;
	}
	
	pgpEnterPGPErrorFunction();
	
	switch( whichTest )
	{
        /* FIPS140 statetrans PGPRunAllSDKSelfTests.1 */
		case kPGPsdkSelfTest_3DES:
			err = pgpTest3DES();
			break;
	
        /* FIPS140 statetrans PGPRunAllSDKSelfTests.3 */
		case kPGPsdkSelfTest_DSA:
			err = pgpTestDSA();
			break;
			
        /* FIPS140 statetrans PGPRunAllSDKSelfTests.5 */
		case kPGPsdkSelfTest_Integrity:
			err = pgpTestSDKIntegrity();
			break;
			
		default:
			pgpDebugMsg( "PGPRunSDKSelfTest: Invalid test selector" );
			err = kPGPError_BadParams;
			break;
	}
	
	if( IsPGPError( err ) )
		pgpSetSDKErrorState( err );
		
	return( err );
}

    PGPError
PGPRunAllSDKSelfTests(void)
{
	PGPsdkSelfTest	whichTest;
	PGPError		err = kPGPError_NoErr;
	
	/*
	** Set sHaveRunAllSelfTests here so pgpEnterPGPErrorFunction() will not
	** return an error is the self tests have not been run. Note that
	** pgpEnterPGPErrorFunction could still return an error if the SDK is
	** in an error state.
	*/
	
	if( ! pgpFIPSModeEnabled() )
	{
		pgpDebugMsg( "PGPRunAllSDKSelfTests: Cannot run self test "
						"without FIPS mode enabled" );
		return kPGPError_BadParams;
	}

	sHaveRunAllSelfTests = TRUE;
	
	pgpEnterPGPErrorFunction();

	for( whichTest = kPGPsdkSelfTest_FirstTest;
			whichTest <= kPGPsdkSelfTest_LastTest;
				++whichTest )
	{
		err = PGPRunSDKSelfTest( whichTest );
		if( IsPGPError( err ) )
			break;
	}
	
	return( err );
}

	PGPError
PGPEnableFIPSMode(void)
{
	sFIPSModeEnabled = TRUE;
	
	return kPGPError_NoErr;
}

	PGPBoolean
pgpFIPSModeEnabled(void)
{
	return sFIPSModeEnabled;
}
